<?php
// Start the session to get the user_id
session_start();

// Include the database connection
include('db.php'); // Assuming you have a db.php file for DB connection

if (!isset($_SESSION['user']) || !isset($_SESSION['user']['user_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.',
        'cart_count' => 0
    ]);
    exit;
}

$user_id = intval($_SESSION['user']['user_id']);
// Read raw POST data for JSON
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Get product_id from the decoded JSON data
$product_id = $data['product_id'] ?? null;

// Check if product_id is provided
if (!$product_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Product ID is required.'
    ]);
    exit;
}

// Update the Delete_status for the product in the cart
$query = "
    UPDATE cart 
    SET Delete_status = 1 
    WHERE User_id = '$user_id' AND Product_id = '$product_id'
";

if (mysqli_query($conn, $query)) {
    // Check if any row was affected
    if (mysqli_affected_rows($conn) > 0) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Product removed from cart successfully.'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'No matching product found in the cart.'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to remove product from cart.'
    ]);
}

// Close the database connection
mysqli_close($conn);
?>
